<?php

namespace V360\Master\Models\Geo;

use V360\Master\Scopes\OrderScope;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Country extends Model
{
  protected $connection = "master";
  protected $table = "geo_countries";

  public $timestamps = true;

  protected $guarded = [
    'id', 'created_at', 'updated_at'
  ];

  protected $casts = [
    'meta' => 'json',
    'has_postal_codes' => 'boolean',
    'geonames_detail' => 'json',
    'created_at' => 'datetime',
    'updated_at' => 'datetime',
  ];

  /**
   * The "booting" method of the model.
   *
   * @return void
   */
  protected static function boot()
  {
    parent::boot();
    static::addGlobalScope(new OrderScope('name', 'asc'));
  }

  /**
   * Relations
   */
  public function states(): HasMany
  {
    return $this->hasMany(State::class, 'country_id', 'id');
  }


  /**
   * Scopes
   */
  public function scopeOfCode($query, $code)
  {
    $query->where('code', $code);
  }
}
