# Master
A master app wrapper for v360 applications.

## Installation

```
$ composer require v360-tech/master
```

## Export

### To publish config
```
php artisan vendor:publish --provider="V360\Master\MasterServiceProvider" --tag="config"
```

## Setup

### Configuration

Default configurations will be available in `v360_master.php` file in config directory. Check this file for more details.

## Usage

### Setup

- Create one connection named `master` in container application's `config\database.php`. This database will be used for getting details from the master database.

### Facades

#### V360Geo

Use `V360\Master\Facades\V360Geo` facade to get detailes related to geo-location models.

It implements method(s) as follows:

  - `countryList($key, $value)` - Get list of country as key-value pair.
    - `$key` - String key field. *default - id*
    - `$value` - String value field. *default - name*
  - `countries($select)` - Get detail of countries.
    - `$select` - Array of fields. *default - [id, name, code, has_postal_code, isd_code]*
  - `stateList($countryId)` - Get list of states for the specified country
    - `$countryId` - Id of country **required**
  - `cityList($stateId)` - Get list of cities for the specified state
    - `$stateId` - Id of state **required**
  - `postalCodeCity($countryId, $postalCode)` - Get list of city for the specified postalcode and country id.
    - `$countryId` - Id of country **required**
    - `$postalCode` - String postal code **required**
