<?php

namespace V360\Master;

use Illuminate\Database\Eloquent\Builder;
use V360\Master\Models\Product\HsnCode;

class V360HsnCode
{
  /**
   * Query builder used for this instance
   *
   * @var Builder
   */
  private $query;

  private mixed $division;
  private array $select = ['code', 'name'];
  private $tags;
  private $tagOp;
  private bool $isService = false;

  public function __construct()
  {
    $this->resetQuery();
  }

  public function resetQuery()
  {
    $this->query = HsnCode::query();
    $this->division = null;
    $this->tags = null;
    $this->tagOp = null;
    $this->isService = false;
    $this->select = ['code', 'name'];
    return $this;
  }

  public function query()
  {
    return $this->resetQuery();
  }

  public function select($fields)
  {
    if (!is_array($fields)) {
      $fields = [$fields];
    }
    $this->select = $fields;
    return $this;
  }

  public function division($division)
  {
    $this->division = $division;
    return $this;
  }

  public function tags($tags, $tagOp = 'OR')
  {
    $this->tags = $tags;
    $this->tagOp = $tagOp;
    return $this;
  }

  public function service()
  {
    $this->isService = true;
  }

  public function product()
  {
    $this->isService = false;
  }

  /**
   * Get list of hsn codes
   *
   * @return Collection
   */
  public function list()
  {
    $results = $this->query
      ->when($this->division, function ($query) {
        $query->ofDivision($this->division);
      })
      ->when($this->isService === true, function ($query) {
        $query->service();
      })
      ->when($this->isService === false, function ($query) {
        $query->product();
      })
      ->when($this->tags, function ($query) {
        $query->ofTags($this->tags, $this->tagOp);
      })
      ->select($this->select)
      ->get();
    $this->resetQuery();
    return $results;
  }
}
