<?php

namespace V360\Master;

use V360\Master\Models\Geo\City;
use V360\Master\Models\Geo\CityPostalCode;
use V360\Master\Models\Geo\Country;
use V360\Master\Models\Geo\State;

class V360Geo
{
  /**
   * Get list of counrties
   *
   * @param string $key
   * @param string $value
   * @return Collection
   */
  public static function countryList(string $key = 'id', string $value = 'name')
  {
    return Country::has('states')->get()->pluck($value, $key);
  }

  /**
   * Get countries
   *
   * @param array $select
   * @return void
   */
  public static function countries(array $select = ['id', 'name', 'code', 'has_postal_code', 'isd_code'])
  {
    return Country::has('states')->select($select)->get();
  }

  /**
   * Get list of states for the country
   *
   * @param integer $countryId
   * @return Collection
   */
  public static function stateList(int $countryId)
  {
    return State::ofCountry($countryId)->get()->pluck('name', 'id');
  }

  /**
   * Get list of states for the country
   *
   * @param integer $stateId
   * @return Collection
   */
  public static function cityList(int $stateId)
  {
    return City::ofState($stateId)->get()->pluck('name', 'id');
  }

  /**
   * Get list of city matches with this postal code
   *
   * @param integer $countryId
   * @param string $postalCode
   * @return CityPostalCode
   */
  public static function postalCodeCity(int $countryId, string $postalCode)
  {
    return CityPostalCode::ofCountry($countryId)
      ->ofPostalCode($postalCode)
      ->select(['city_id', 'state_id'])
      ->first();
  }
}
