<?php

namespace V360\Master\Models\Geo;

use V360\Master\Scopes\OrderScope;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class City extends Model
{
  protected $connection = "master";
  protected $table = "geo_cities";

  public $timestamps = true;

  protected $guarded = [
    'id', 'created_at', 'updated_at'
  ];

  protected $casts = [
    'meta' => 'json',
    'geonames_detail' => 'json',
    'created_at' => 'datetime',
    'updated_at' => 'datetime',
  ];

  /**
   * The "booting" method of the model.
   *
   * @return void
   */
  protected static function boot()
  {
    parent::boot();
    static::addGlobalScope(new OrderScope('name', 'asc'));
  }

  /**
   * Relations
   */
  public function state(): BelongsTo
  {
    return $this->belongsTo(State::class, 'state_id', 'id');
  }
  public function city_postal_codes(): HasMany
  {
    return $this->hasMany(CityPostalCode::class, 'city_id', 'id');
  }

  /**
   * Scopes
   */
  public function scopeOfState($query, $stateId)
  {
    $query->where('state_id', $stateId);
  }
}
