<?php

namespace V360\Master;

use Illuminate\Support\ServiceProvider;
use V360\Master\V360Geo;
use V360\Master\V360HsnCode;

class MasterServiceProvider extends ServiceProvider
{
  /**
   * Register service provider
   *
   * @return void
   */
  public function register()
  {
    //merge config
    $this->mergeConfigFrom(__DIR__ . '/../config/config.php', 'v360_master');
    $this->app->bind(V360HsnCode::class, function ($app) {
      return new V360HsnCode();
    });
    $this->app->bind(V360Geo::class, function ($app) {
      return new V360Geo();
    });
  }

  /**
   * Initialization
   *
   * @return void
   */
  public function boot()
  {
    //config
    if ($this->app->runningInConsole()) {
      // publish the configs
      $this->publishes([
        __DIR__ . '/../config/config.php' => config_path('v360_master.php'),
      ], 'config');
    }
  }
}
