<?php

namespace V360\Master\Scopes;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Scope;

class OrderScope implements Scope
{
  private $column;
  private $direction;

  public function __construct($column = 'id', $direction = 'asc')
  {
    $this->column = $column;
    $this->direction = $direction;
  }

  /**
   * Apply the scope to a given Eloquent query builder.
   *
   * @param  \Illuminate\Database\Eloquent\Builder  $builder
   * @param  \Illuminate\Database\Eloquent\Model  $model
   * @return void
   */
  public function apply(Builder $builder, Model $model)
  {
    $builder->orderBy($model->getTable() . "." . $this->column, $this->direction);
  }
}
