<?php

namespace V360\Master\Models\Product;

use V360\Master\Scopes\OrderScope;
use Illuminate\Database\Eloquent\Model;
use V360\Master\Enums\Product\Division;

class HsnCode extends Model
{
  protected $connection = "master";
  protected $table = "product_hsn_codes";

  public $timestamps = true;

  protected $fillable = [];

  protected $casts = [
    'tags' => 'array',
    'division' => Division::class,
    'created_at' => 'datetime',
    'updated_at' => 'datetime',
  ];

  /**
   * The "booting" method of the model.
   *
   * @return void
   */
  protected static function boot()
  {
    parent::boot();
    static::addGlobalScope(new OrderScope('name', 'asc'));
  }

  /**
   * Scopes
   */
  public function scopeOfDivision($query, $division)
  {
    $query->where('division', $division);
  }
  public function scopeService($query)
  {
    $query->where('is_service', true);
  }
  public function scopeProduct($query)
  {
    $query->where('is_service', false);
  }
  public function scopeOfTags($query, $tags, $tagOp = 'OR')
  {
    if (is_array($tags) && $tagOp == 'OR') {
      $query->where(function ($query) use ($tags) {
        foreach ($tags as $tag) {
          $query->orWhere(function ($query) use ($tag) {
            $query->whereJsonContains('tags', $tag);
          });
        };
      });
    } else {
      $query->whereJsonContains('tags', $tags);
    }
  }
}
