<?php

namespace V360\Master\Models\Geo;

use V360\Master\Scopes\OrderScope;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class State extends Model
{
  protected $connection = "master";
  protected $table = "geo_states";
  public $timestamps = true;

  protected $guarded = [
    'id', 'created_at', 'updated_at'
  ];

  protected $casts = [
    'meta' => 'json',
    'geonames_detail' => 'json',
    'created_at' => 'datetime',
    'updated_at' => 'datetime',
  ];

  /**
   * The "booting" method of the model.
   *
   * @return void
   */
  protected static function boot()
  {
    parent::boot();
    static::addGlobalScope(new OrderScope('name', 'asc'));
  }

  /**
   * Relations
   */
  public function country(): BelongsTo
  {
    return $this->belongsTo(Country::class, 'country_id', 'id');
  }
  public function cities(): HasMany
  {
    return $this->hasMany(City::class, 'state_id', 'id');
  }

  /**
   * Scopes
   */
  public function scopeOfCountry($query, $countryId)
  {
    $query->where('country_id', $countryId);
  }
  public function scopeOfCountryCode($query, $countryCode)
  {
    $query->whereHas('country', function ($query) use ($countryCode) {
      $query->where('code', $countryCode);
    });
  }
}
