<?php

namespace V360\Master\Models\Geo;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CityPostalCode extends Model
{
  protected $connection = "master";
  protected $table = "geo_city_postal_codes";
  public $timestamps = false;

  protected $guarded = [
    'id'
  ];

  protected $casts = [
    'is_processed' => 'boolean'
  ];

  /**
   * Relations
   */
  public function country(): BelongsTo
  {
    return $this->belongsTo(Country::class, 'country_id', 'id');
  }
  public function city(): BelongsTo
  {
    return $this->belongsTo(City::class, 'city_id', 'id');
  }

  public function scopeOfCountry($query, $countryId)
  {
    $query->where('country_id', $countryId);
  }
  public function scopeOfCity($query, $cityId)
  {
    $query->where('city_id', $cityId);
  }
  public function scopeOfPostalCode($query, $postalCode)
  {
    $query->where('code', 'LIKE',  "%{$postalCode}%");
  }
}
