<?php

namespace V360\ExpoPusher\Repositories;

use ExponentPhpSDK\Repositories\ExpoFileDriver;
use Illuminate\Support\Facades\File;

class ExpoPusherFileDriver extends ExpoFileDriver
{

  /**
   * Construct a new instance
   *
   * @param string $storagePath
   */
  public function __construct($storagePath)
  {
    if ($storagePath) {
      //check path existance
      $path = storage_path("app/" . $storagePath);
      $dirname = dirname($path);
      if (!File::exists($dirname)) {
        File::makeDirectory($dirname, 0755, true);
      }

      //set storage of driver
      $this->setStorage($path);
    }
  }

  /**
   * Check whether specified key exists in store or not
   *
   * @param string $key
   * @return bool
   */
  public static function exists(string $key): bool
  {
    $filePath = config('expo_pusher.drivers.file.path');
    $instance = new ExpoPusherFileDriver($filePath);
    return !is_null($instance->retrieve($key));
  }
}
