<?php

return [

  /**
   * Access Token for Secure Push
   * This token could be generated via Expo portal.
   *      
   */
  'access_token' => env('V360_EXPO_PUSHER_ACCESS_TOKEN', ''),

  /**
   * Debugging notifications
   */
  'debug' => env('V360_EXPO_PUSHER_DEBUG', true),

  /**
   * Store drivers configurations
   */
  'drivers' => [
    /**
     * Name of driver
     * Supported - file | database | redis
     */
    'name' => env('V360_EXPO_PUSHER_DRIVER', 'file'),

    /**
     * File specific configuration
     */
    'file' => [
      'path' => env('V360_EXPO_PUSHER_STORAGE_PATH', '/expo-pusher/tokens.json'),
    ],

    /**
     * Redis specific configuration
     */
    'redis' => [
      'connection' => env('V360_EXPO_PUSHER_REDIS_CONNECTION', 'default')
    ]
  ],

  /**
   * Route parameters
   */
  'route' => [
    /**
     * Name prefix 
     * Routes will be available with this name
     */
    'name' => 'api.expo-pusher',
    /**
     * URL prefix
     * Routes will be available with this prefix
     */
    'prefix' => 'api/expo-pusher',
    /**
     * Middleware
     */
    'middleware' => ['auth:sanctum']
  ],

];
