# Expo Pusher
An expo pusher package based on exponent-server-sdk-php

## Installation

```
$ composer require v360-tech/expo-pusher
```

In case your Laravel version does NOT autoload the packages, add the service provider to config/app.php:

```
V360\ExpoPusher\ExpoPusherServiceProvider::class,
```

## Publishing

### To publish config
```
php artisan vendor:publish --provider="V360\ExpoPusher\ExpoPusherServiceProvider" --tag="config"
```

### To publish migration
```
php artisan vendor:publish --provider="V360\ExpoPusher\ExpoPusherServiceProvider" --tag="migrations"
```

### To publish notification
In order to understand how to use this package, sample Laravel Notification is added to source. To publish the same run the following command.
```
php artisan vendor:publish --provider="V360\ExpoPusher\ExpoPusherServiceProvider" --tag="notification"
```

## Setup

### Prerequisites
> #### Drivers Support
>
> - **`file`** - No additional setup required
> - **`database`** - Run migrations
> - **`redis`** - Set up redis server as per Laravel documentation


### Configuration

Default configurations will be available in `expo_pusher.php` file in config directory. 
You are required to create following environment variables. 

- `V360_EXPO_PUSHER_ACCESS_TOKEN`,
- `V360_EXPO_PUSHER_DEBUG`,
- `V360_EXPO_PUSHER_DRIVER`,
- `V360_EXPO_PUSHER_REDIS_CONNECTION`,
- `V360_EXPO_PUSHER_STORAGE_PATH`

Explore config file for more detail.

### Migrations

If you are planning to use database driver for this package then you are required to run the migrations via following command.

```
$ php artisan migrate
```

## Use

### Subscription

This package will create following two routes/endpoints for subscription service. Prefix of this endpoints are configurable.

#### Subscribe

Subscribe the user for push notification. This api should be consumed by the user device upon successful login.

**URL** `/subscribe`

**Method** `POST`

**Auth required** : YES

**Request**
```json
{
  "token" : "ExponentPushToken[unique]"
}
```
**Response**

- **200** - Subscribed
- **400** - Expo token is required
- **401** - You are not authorised to subscribe
- **500** - Server Error

#### Unsubscribe

Unubscribe the user for push notification. This api should be consumed by the user device upon successful logout.

**URL** `/unsubscribe`

**Method** `POST`

**Auth required** : YES

**Request**
```json
{
  "token" : "ExponentPushToken[unique]"
}
```
**Response**

- **200** - Unsubscribed
- **400** - Expo token is required
- **401** - You are not authorised to subscribe
- **500** - Server Error

### Sending Notifications

See sample `ExpoPusherNotification` for more detail. 


## Licence

Proprietery