<?php

namespace V360\ExpoPusher\Repositories;

use V360\ExpoPusher\ExpoPusherRepository;
use Illuminate\Support\Facades\Redis;

class ExpoPusherRedisDriver implements ExpoPusherRepository
{

  /**
   * Name of connection
   *
   * @var string
   */
  public $connection;

  /**
   * Create redis instance
   *
   * @param string $connection
   */
  public function __construct($connection = null)
  {
    $this->connection = $connection;
  }

  /**
   * Stores an Expo token with a given identifier.
   *
   * @param $key
   * @param $deviceToken
   *
   * @return bool
   */
  public function store($key, $deviceToken): bool
  {
    if ($this->connection) {
      $interest = Redis::connection($this->connection)->set($key, $deviceToken);
    } else {
      $interest = Redis::set($key, $deviceToken);
    }
    return is_object($interest);
  }

  /**
   * Retrieves an Expo token with a given identifier.
   *
   * @param  string  $key
   * 
   * @return array
   */
  public function retrieve(string $key)
  {
    if ($this->connection) {
      $value = Redis::connection($this->connection)->get($key);
    } else {
      $value = Redis::get($key);
    }
    return [$value];
  }

  /**
   * Removes an Expo token with a given identifier.
   *
   * @param  string  $key
   * @param  string  $deviceToken
   *
   * @return bool
   */
  public function forget(string $key, ?string $deviceToken = null): bool
  {
    if ($this->connection) {
      $deleted = Redis::connection($this->connection)->del($key);
    } else {
      $deleted = Redis::del($key);
    }
    return $deleted > 0;
  }

  /**
   * Check whether specified key exists in store or not
   *
   * @param string $key
   * @return bool
   */
  public static function exists(string $key): bool
  {
    $connection = config('expo_pusher.drivers.redis.connection');
    if ($connection) {
      $value = Redis::connection($connection)->get($key);
    } else {
      $value = Redis::get($key);
    }
    return !is_null($value);
  }
}
