<?php

namespace V360\ExpoPusher\Repositories;

use V360\ExpoPusher\Exceptions\ExpoPusherException;
use V360\ExpoPusher\ExpoPusherRepository;
use V360\ExpoPusher\Models\ExpoPusherSubscriber;

class ExpoPusherDatabaseDriver implements ExpoPusherRepository
{
  /**
   * Stores an Expo token with a given identifier.
   *
   * @param $key
   * @param $deviceToken
   *
   * @return bool
   */
  public function store($key, $deviceToken): bool
  {
    $interest = ExpoPusherSubscriber::firstOrCreate([
      'key' => $key,
      'device_token' => $deviceToken
    ], [
      'at' => date("Y-m-d H:i:s")
    ]);

    return $interest instanceof ExpoPusherSubscriber;
  }

  /**
   * Retrieves an Expo token with a given identifier.
   *
   * @param  string  $key
   * 
   * @return array
   */
  public function retrieve(string $key)
  {
    return ExpoPusherSubscriber::where('key', $key)->pluck('device_token')->toArray();
  }

  /**
   * Removes an Expo token with a given identifier.
   *
   * @param  string  $key
   * @param  string  $deviceToken
   *
   * @return bool
   */
  public function forget(string $key, ?string $deviceToken = null): bool
  {
    $query = ExpoPusherSubscriber::where('key', $key);

    if ($deviceToken) {
      $query->where('device_token', $deviceToken);
    }

    if ($query->doesntExist()) {
      throw new ExpoPusherException("Invalid token", 1);
    }

    return $query->delete() > 0;
  }

  /**
   * Check whether specified key exists in database or not
   *
   * @param string $key
   * @return bool
   */
  public static function exists(string $key): bool
  {
    return ExpoPusherSubscriber::where('key', '=', $key)->exists();
  }
}
