<?php

namespace App\Notifications;

use Illuminate\Notifications\Notification;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use V360\ExpoPusher\ExpoChannel;
use V360\ExpoPusher\ExpoMessage;

class ExpoPusherNotification extends Notification implements ShouldQueue
{
  use Queueable;

  /**
   * Notifciation body
   *
   * @var string
   */
  public $body;

  public function __construct($body)
  {
    $this->body = $body ?? "Welcome to our world";
  }

  /**
   * Get the notification channels.
   *
   * @param  mixed  $notifiable
   * @return array|string
   */
  public function via($notifiable)
  {
    return [ExpoChannel::class];
  }

  /**
   * Get the expo message representaion of message
   *
   * @param  mixed  $notifiable
   * @return ExpoMessage
   */
  public function toExpoPush($notifiable)
  {
    //create instance
    // $expoMessage = new ExpoMessage($this->body);
    // $expoMessage->badge(1)
    //   ->disableSound()
    //   ->title("Congratulations!");
    // return $expoMessage;

    //or return via facade
    return ExpoMessage::create()
      ->badge(1)
      ->disableSound()
      ->title("Congratulations!")
      ->body($this->body);
  }

  /**
   * Determine if the notification should be sent.
   *
   * @param  mixed  $notifiable
   * @param  string  $channel
   * @return bool
   */
  public function shouldSend($notifiable, $channel)
  {
    //check whether notifiable is subscribed to receive
    return ExpoChannel::isSubscribed($notifiable);
  }
}
