<?php

namespace V360\ExpoPusher\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use V360\ExpoPusher\ExpoChannel;

class ExpoPusherController extends Controller
{
  /**
   * @var ExpoChannel
   */
  private $expoChannel;

  /**
   * ExpoController constructor.
   *
   * @param  ExpoChannel  $expoChannel
   */
  public function __construct(ExpoChannel $expoChannel)
  {
    $this->expoChannel = $expoChannel;
  }


  /**
   * Subscibe a new user
   *
   * @param  \Illuminate\Http\Request  
   * @return \Illuminate\Http\Response
   */
  public function subscribe(Request $request)
  {
    //
    $validator = Validator::make($request->all(), [
      'token' => 'required|string',
    ]);

    if ($validator->fails()) {
      return response()->json("Expo token is required", 400);
    }

    //get user
    $user = Auth::user();
    if (!$user) {
      return response()->json("You are not authorised to subscribe.", 401);
    }

    //prepare interest
    $interest = $this->expoChannel->prepareInterest(Auth::user());

    try {
      $this->expoChannel->expo->subscribe($interest, $request->token);
    } catch (\Throwable $th) {
      return response()->json($th->getMessage(), 500);
    }
    return response()->json("Subscribed", 200);
  }

  /**
   * Unsubscibe a new user
   *
   * @param  \Illuminate\Http\Request  
   * @return \Illuminate\Http\Response
   */
  public function unsubscribe(Request $request)
  {
    //
    $validator = Validator::make($request->all(), [
      'token' => 'sometimes|string',
    ]);

    if ($validator->fails()) {
      return response()->json("Expo token is invalid", 400);
    }

    //get user
    $user = Auth::user();
    if (!$user) {
      return response()->json("You are not authorised to unsubscribe.", 401);
    }

    //prepare interest
    $interest = $this->expoChannel->prepareInterest(Auth::user());

    //unsubscribe
    try {
      $this->expoChannel->expo->unsubscribe($interest, $request->token);
    } catch (\Throwable $th) {
      return response()->json($th->getMessage(), 500);
    }
    return response()->json("Unsubscribed", 200);
  }
}
