<?php

namespace V360\DurationLogger\Traits;

use Illuminate\Database\Eloquent\Relations\MorphMany;
use V360\DurationLogger\Enums\DurationFrequency;
use V360\DurationLogger\Enums\ScoreType;
use V360\DurationLogger\Models\DurationLogger;

trait HasDurationLogs
{

  /**
   * Defines whether secondory key is to be looged or not
   *
   * @var boolean
   */
  protected $defaultScoreWithDetail = false;

  /**
   * Defines what to score
   *
   * @var array
   */
  protected $defaultScoreTypes = [
    ScoreType::DEVICE_TYPE,
    ScoreType::BROWSER_FAMILY,
    ScoreType::PLATFORM_FAMILY
  ];

  /**
   * Defines at what duration score is to be reset
   *
   * @var array
   */
  protected $defaultDurationFrequencies = [
    DurationFrequency::DAY,
    DurationFrequency::YEAR
  ];

  /**
   * Get score with detail or not
   *
   * @return boolean
   */
  public function getScoreWithDetail(): bool
  {
    return $this->scoreWithDetail ?? $this->defaultScoreWithDetail;
  }

  /**
   * Get score types to be logged
   *
   * @return array
   */
  public function getScoreTypes(): array
  {
    return $this->scoreTypes ?? $this->defaultScoreTypes;
  }

  /**
   * Get duration frequency of logging
   * After every this durtion a new records is to be inserted, otherwise existiing record is to be updated
   *
   * @return array
   */
  public function getDurationFrequencies(): array
  {
    return $this->durationFrequencies ?? $this->defaultDurationFrequencies;
  }

  /**
   * Relation
   *
   * @return MorphMany
   */
  public function duration_logs(): MorphMany
  {
    return $this->morphMany(DurationLogger::class, 'loggable');
  }
}
