<?php

namespace V360\DurationLogger;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Support\ServiceProvider;
use V360\DurationLogger\Console\ClearPendingSync;
use V360\DurationLogger\Console\SyncCacheDatabase;
use V360\DurationLogger\LogDuration;
use V360\DurationLogger\StatsDuration;

class DurationLoggerServiceProvider extends ServiceProvider
{
  /**
   * Register service provider
   *
   * @return void
   */
  public function register()
  {
    //merge config
    $this->mergeConfigFrom(__DIR__ . '/../config/config.php', 'durationlogger');
    $this->app->bind(LogDuration::class, function ($app) {
      return new LogDuration();
    });
    $this->app->bind(StatsDuration::class, function ($app) {
      return new StatsDuration();
    });
  }

  /**
   * Initialization
   *
   * @return void
   */
  public function boot()
  {
    //migrations    
    $this->loadMigrationsFrom(__DIR__ . '/../database/migrations');

    //config
    if ($this->app->runningInConsole()) {
      // publish the configs
      $this->publishes([
        __DIR__ . '/../config/config.php' => config_path('durationlogger.php'),
      ], 'config');

      // sync command
      $this->commands([
        SyncCacheDatabase::class,
        ClearPendingSync::class,
      ]);

      // run sync command every minute
      $this->app->booted(function () {
        $schedule = $this->app->make(Schedule::class);
        $schedule->command('v360:durationlogger:sync')->everyMinute();
        $schedule->command('v360:durationlogger:clear')->dailyAt('01:00');
      });
    }
  }
}
