<?php

namespace V360\DurationLogger\Console;

use Illuminate\Console\Command;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use V360\DurationLogger\Models\DurationLogger;

class ClearPendingSync extends Command
{
  protected $signature = 'v360:durationlogger:clear';

  protected $description = 'Clear pending synced data and store it into the database.';

  public function handle()
  {
    //all records
    $cachedRecords = Cache::get(DurationLogger::CACHE_KEY);
    if (!$cachedRecords) {
      return;
    }
    $tsKeys = array_keys($cachedRecords);
    $todayKey = Carbon::tomorrow()->startOfDay()->timestamp;
    foreach ($tsKeys as $nowKey) {
      if ($nowKey < $todayKey) {
        $cachedNowRecords = $cachedRecords[$nowKey] ?? [];
        if ($cachedNowRecords) {
          foreach ($cachedNowRecords as $record) {
            try {
              DurationLogger::updateOrCreate(
                [
                  "loggable_type" => $record['loggable_type'],
                  "loggable_id" => $record['loggable_id'],
                  "score_type" => $record['score_type'] ?? null,
                  "score_value" => $record['score_value'] ?? null,
                  "duration_type" => $record['duration_type'],
                  "duration_at" => $record['duration_at'],
                ],
                [
                  'score' => DB::raw("score + " . $record['factor'])
                ]
              );
            } catch (\Throwable $th) {
              Log::error(__CLASS__, [$th->getMessage(), $th->getLine(), $record]);
            }
          }
          unset($cachedRecords[$nowKey]);
        }
      }
    }
    Cache::put(DurationLogger::CACHE_KEY, $cachedRecords);
  }
}
