<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use V360\DurationLogger\Enums\DurationFrequency;
use V360\DurationLogger\Enums\ScoreType;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('v360_duration_logs', function (Blueprint $table) {
      $table->id();
      $table->string('loggable_type');
      $table->unsignedBigInteger('loggable_id')->nullable();
      $table->enum('score_type', ScoreType::values())->nullable();
      $table->string('score_value')->nullable();
      $table->unsignedBigInteger('score')->default(0);
      $table->enum('duration_type', DurationFrequency::values())->default(DurationFrequency::DAY);
      $table->timestamp('duration_at');
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('v360_duration_logs');
  }
};
