<?php

namespace V360\DurationLogger\Enums;

enum ScoreType: string
{

  case DEVICE_TYPE = 'DEVICE_TYPE';
  case BROWSER_NAME = 'BROWSER_NAME';
  case BROWSER_FAMILY = 'BROWSER_FAMILY';
  case PLATFORM_NAME = 'PLATFORM_NAME';
  case PLATFORM_FAMILY = 'PLATFORM_FAMILY';

  public static function list(): array
  {
    return array_column(self::cases(), 'name', 'value');
  }

  public static function values(): array
  {
    return array_column(self::cases(), 'value');
  }
}
