# Duration Logger
An eloquent visit logger package for Laravel based application

## Installation

```
$ composer require v360-tech/durationlogger
```

In case your Laravel version does NOT autoload the packages, add the service provider to config/app.php:

```
V360\DurationLogger\DurationLoggerServiceProvider::class,
```

## Export

### To publish config
```
php artisan vendor:publish --provider="V360\DurationLogger\DurationLoggerServiceProvider" --tag="config"
```

## Setup

### Configuration

Default configurations will be available in `durationlogger.php` file in config directory. Check this file for more details.

### Migrations

Run the migrations via following command. It will create required tables.

```
$ php artisan migrate
```

### Caching

This package makes use of `Cache` for better performance. Appropriate setup is required for the same.

## Usage

### Setup

- Use `V360\DurationLogger\Traits\HasDurationLogs` trait for any model for which you want to preserve visit logs.
- The model should define following properties to customize the behaviour of logging.
  - `scoreWithDetail` : *Boolean* value to decide whether per instance logging is to be kept or not.
  - `scoreKey` : *String* value which determines the morph key for the model in consideration. In case not specified, class name will be used as model key.
  - `scoreTypes` : *Array* of enum values, which determines what type of detailes is to be logged. Available options are defined in enum `V360\DurationLogger\Enums\ScoreType`.
  - `durationFrequencies` : *Array* of enum values, which specified frequency of logging. Available opetions are deigned in enum `V360\DurationLogger\Enums\DurationFrequency`.
- In case, `scoreWithDetail` is `true`
  - Relation `duration_logs` will be available to the model in consideration.
  - This can be used for instance wise count details for any record.

### Logging

- Use `V360\DurationLogger\Facades\LogDuration` facade to log visits for the model. 
- It implements three method(s) as follows:
  - `increment($model, $step)` - 
    - `$model` - Eloquent model reference. *required*
    - `$step` - Integer step value for performing bulk increment. *Default - 1*
  - `decrement($model, $step)` : Definition same as increment, only difference is it will reduce visit count instead of increase it.
  - `score` : Last method in facade chain to perform actual store operation. 
  
```php
$user = User::first():

# increment user visit by 1
LogDuration::increment($user)->score();

# decrement user visit by 2
LogDuration::decrement($user, 2)->score();
```