<?php

namespace V360\ShowComponents\View\Components;

use Illuminate\View\Component;

class Features extends Component
{
  public $items;
  public $label;
  public ?string $icon = null;
  public string $classes;
  public string $tagColor;
  public string $tagIcon;
  public string $tagSize;
  public int $size = 7;


  /**
   * Create a new component instance.
   *
   * @return void
   */
  /**
   * Create a new component instance.
   *
   * @param array|Collection $items
   * @param string|bool $label
   * @param string $icon
   * @param string $classes
   * @param string $tagColor
   * @param string $tagIcon
   * @param string $tagSize
   */
  public function __construct(
    $items = null,
    $label = null,
    string $icon = null,
    string $classes = 'has-text-black',
    string $tagColor = 'is-success',
    string $tagIcon = 'fa-check',
    string $tagSize = 'is-small'
  ) {
    //
    $this->label = $label;
    $this->items = $items;
    $this->icon = $icon ?? 'short_text';
    $this->classes = $classes;
    $this->tagColor = $tagColor;
    $this->tagIcon = $tagIcon;
    $this->tagSize = $tagSize;
    $this->size =  $tagSize == 'is-large' || $tagSize == 'is-medium' ? 5 : 7;
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vshow::components.features');
  }
}
