<?php

namespace V360\ShowComponents;

use Illuminate\Support\ServiceProvider;
use V360\ShowComponents\View\Components\Breadcrumb;
use V360\ShowComponents\View\Components\Collection;
use V360\ShowComponents\View\Components\Features;
use V360\ShowComponents\View\Components\Info;
use V360\ShowComponents\View\Components\InfoList;
use V360\ShowComponents\View\Components\Loading;
use V360\ShowComponents\View\Components\Modalshow;
use V360\ShowComponents\View\Components\Norecords;
use V360\ShowComponents\View\Components\Notfound;
use V360\ShowComponents\View\Components\Status;
use V360\ShowComponents\View\Components\Timestamps;
use V360\ShowComponents\View\Components\Userstamps;

class ShowComponentsServiceProvider extends ServiceProvider
{
    /**
     * Register service provider
     *
     * @return void
     */
    public function register()
    {

        if ($this->app->runningInConsole()) {
            // Publish view components
            $this->publishes([
                __DIR__ . '/../src/View/Components/' => app_path('View/Components/vshow'),
                __DIR__ . '/../resources/views/components/' => resource_path('views/components/vshow'),
            ], 'vshow');
        }
    }

    /**
     * Initialization
     *
     * @return void
     */
    public function boot()
    {

        // ... other things
        $this->loadViewsFrom(__DIR__ . '/../resources/views', 'vshow');

        //regiter components
        $this->loadViewComponentsAs('vshow', [
            Breadcrumb::class,
            Collection::class,
            Features::class,
            Info::class,
            InfoList::class,
            Loading::class,
            Modalshow::class,
            Notfound::class,
            Norecords::class,
            Status::class,
            Userstamps::class,
            Timestamps::class,
        ]);
    }
}
