# Show Components
A package for show components based on Laravel and Bulma.

## Dependencies

- [Laravel Collective](https://laravelcollective.com/)
- [jQuery](https://jquery.com/)

## Installation

```
$ composer require v360-tech/components-show
```

In case your Laravel version does NOT autoload the packages, add the service provider to config/app.php:

```
V360\ShowComponents\ShowComponentsServiceProvider::class,
```

## Export

### To publish views
```
php artisan vendor:publish --provider="V360\ShowComponents\ShowComponentsServiceProvider" --tag="vshow"
```

## Use

This package implements following list of components.

| Element          | Tag                     |
| :--------------- | ----------------------- |
| Breadcrumb       | \<x-vshow-breadcrumb /> |
| Collection       | \<x-vshow-collection /> |
| Features         | \<x-vshow-features />   |
| Info             | \<x-vshow-info />       |
| InfoList         | \<x-vshow-info-list />  |
| Loading          | \<x-vshow-loading />    |
| Modal Show       | \<x-vshow-modalshow />  |
| Not Found        | \<x-vshow-notfound />   |
| No Records Found | \<x-vshow-norecords />  |
| Status           | \<x-vshow-status />     |
| Timestamps       | \<x-vshow-timestamps /> |
| Userstamps       | \<x-vshow-userstamps /> |

### Loading
Add following code to projects's `scss` file.
```
.loader-wrapper {
    transition: opacity .3s;
    display: none;

    .loader {
        height: 40px;
        width: 40px;
    }

    &.is-active {
        display: flex;
        justify-content: center;
        align-items: center;
        flex-direction: column;
        border-radius: 6px;
    }
}
```