<?php

namespace V360\ShowComponents\View\Components;

use Illuminate\View\Component;

class Loading extends Component
{

    /**
     * @var string
     */
    public string $isActive;
    public string $message;

    /**
     * Create a new component instance.
     *
     * @param string $message
     * @param boolean $isActive
     */
    public function __construct($message = "Loading", $isActive = false)
    {
        $this->message = $message;
        if ($isActive) {
            $this->isActive = 'is-active';
        } else {
            $this->isActive = '';
        }
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\View\View|string
     */
    public function render()
    {
        return view('vshow::components.loading');
    }
}
