<?php

namespace V360\ShowComponents\View\Components;

use Illuminate\View\Component;

class Collection extends Component
{
  public $items;
  public bool $keys;
  public string $color;
  public ?string $label = null;
  public ?string $icon = null;
  public ?string $align = null;

  /**
   * Create a new component instance.
   *
   * @param mixed $items
   * @param boolean $keys
   * @param string $color
   * @param string $label
   * @param string $icon
   * @param string $align
   */
  public function __construct(
    $items,
    bool $keys = true,
    string $color = 'is-info',
    string $label = null,
    string $icon = null,
    string $align = 'left'
  ) {
    $this->items = $items;
    $this->keys = $keys;
    $this->color = $color;
    $this->label = $label;
    $this->icon = $icon ?? 'short_text';
    $this->align = $align;
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vshow::components.collection');
  }
}
