<div class="p-2">
    <div @class([
        'is-flex',
        'is-align-items-center',
        'is-justify-content-end is-flex-direction-row-reverse' => $align == 'right',
        'is-justify-content-center is-flex-direction-column' =>
            $align == 'centered',
        'mb-2',
    ])>
        <span @class([
            'icon is-small',
            'mr-3' => $align == 'left',
            'ml-3' => $align == 'right',
            'mb-1' => $align == 'centered',
        ])>
            @if (Str::startsWith($icon, 'fa'))
                <i class="{{ $icon }}"></i>
            @else
                <span class="material-symbols-outlined is-size-6">
                    {{ $icon }}
                </span>
            @endif
        </span>
        <span class="is-size-7 is-italic">
            {{ $label }}
        </span>
    </div>
    <div @class([
        'pl-5 ml-1' => $align == 'left',
        'pr-5 mr-1 has-text-right' => $align == 'right',
        'has-text-centered' => $align == 'centered',
    ])>
        @if ($value)
            <div class="{{ $classes }}">
                @if ($isUrl)
                    <a href="{{ $value }}" target="blank">{{ $value }}</a>
                @else
                    {{ $value }}
                @endif
            </div>
        @endif
        @if ($slot)
            {{ $slot }}
        @endif
    </div>
</div>
