<?php

namespace V360\ShowComponents\View\Components;

use Illuminate\View\Component;

class VideoStreamPlayer extends Component
{

  /**
   * The attributes for the video tag.
   */
  public string $attrs = '';

  /**
   * Create a new component instance.
   *
   * @param string $id - the id of the video element
   * @param string|null $url - the url of the video
   * @param string|null $posterUrl - the poster url of the video
   * @param array|null $options - the options for the video tag
   */
  public function __construct(
    public string $id,
    public ?string $url = null,
    public ?string $posterUrl = null,
    public ?array $options = null,
  ) {
    //
    $this->options = $options ?? [
      'autoplay' => false,
      'controls' => true,
      'controlslist' => 'nodownload', // 'nodownload', 'nofullscreen', 'noremoteplayback'
      'crossorigin' => 'anonymous', // 'anonymous', 'use-credentials'
      'disablepictureinpicture' => true,
      'disableremoteplayback' => true,
      'loop' => false,
      'muted' => false,
      'playsinline' => true,
      'preload' => 'metadata', // 'none', 'metadata', 'auto'
      'poster' => $this->posterUrl ?? '',
    ];
    // genereate attribute bag for the video tag using the options
    $this->attrs = collect($this->options)
      ->filter(fn($value) => $value !== false && $value !== '') // skip false and empty values
      ->map(fn($value, $key) => $value === true ? $key : $key . '=' . $value) // convert to key="value" or key
      ->join(' ');
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vshow::components.video-stream-player');
  }
}
