<?php

namespace V360\ShowComponents\View\Components;

use Illuminate\Support\Str;
use Illuminate\View\Component;

class Modalshow extends Component
{
    public string $id;
    public string $title;
    public ?string $tooltip = null;
    public string $icon;
    public string $size;

    /**
     * Create a new component instance.
     *
     * @param string $title
     * @param string $icon
     * @param string $tooltip
     * @param string $size
     */
    public function __construct(
        string $title = "",
        string $icon = 'fas fa-external-link-square-alt',
        string $tooltip = null,
        string $size = 'medium'
    ) {
        $this->id = Str::uuid();
        $this->title = $title;
        $this->tooltip = $tooltip;
        $this->icon = $icon;
        switch ($size) {
            case 'small':
                $this->size = '';
                break;
            case 'medium':
                $this->size = 'is-modal-medium';
                break;
            case 'large':
                $this->size = 'is-modal-large';
                break;
        }
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\View\View|string
     */
    public function render()
    {
        return view('vshow::components.modalshow');
    }
}
