<?php

namespace V360\ShowComponents\View\Components;

use Illuminate\View\Component;

class InfoList extends Component
{

  /**
   * List of items
   *
   * @var [type]
   */
  public $items;

  /**
   * Classes applied to label of information
   *
   * @var string|null
   */
  public ?string $labelClasses = null;

  /**
   * Classes applied to value
   *
   * @var string|null
   */
  public ?string $contentClasses = null;

  /**
   * Constructor
   *
   * @param [type] $items
   * @param string $labelClasses
   * @param string $contentClasses
   */
  public function __construct(
    $items,
    string $labelClasses = null,
    string $contentClasses = null
  ) {
    $this->items = $items;
    $this->labelClasses = $labelClasses ?? 'is-italic has-text-info-dark has-text-right';
    $this->contentClasses = $contentClasses;
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\Contracts\View\View|string
   */
  public function render()
  {
    return view('vshow::components.info-list');
  }
}
