<?php

namespace V360\ShowComponents\View\Components;

use Illuminate\View\Component;

class Loading extends Component
{

  /**
   * Create a new Loading component instance.
   *
   * @param string  $message  The loading message to display (default: "Loading")
   * @param bool    $isActive Whether the loading state is active (default: false)
   * 
   * @return void
   */
  public function __construct(
    public string $message = "Loading",
    public bool $isActive = false
  ) {
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vshow::components.loading');
  }
}
