<?php

namespace V360\ShowComponents\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class InfoCount extends Component
{
  /**
   * Create a new InfoCount component instance.
   *
   * @param string $info  The information text to display
   * @param mixed  $count The count value to display
   * @param string $color The color theme of the count (default: 'info')
   * @param int    $width The width of the component in pixels (default: 128)
   * 
   * @return void
   */
  public function __construct(
    public string $info,
    public mixed $count,
    public string $color = 'info',
    public int $width = 128
  ) {
  }

  /**
   * Get the view / contents that represent the component.
   */
  public function render(): View|Closure|string
  {
    return view('vshow::components.info-count');
  }
}
