<?php

namespace V360\ShowComponents\View\Components;

use Illuminate\View\Component;

class Info extends Component
{

  /**
   * Create a new Info component instance.
   *
   * @param string  $type    Display type: 'text', 'amount', 'timestamp', or 'date' (default: 'text')
   * @param string  $classes Additional CSS classes (default: '')
   * @param string  $align   Text alignment: 'left', 'right', 'center' (default: 'left')
   * @param bool    $isUrl   Whether the value is a URL (default: false)
   * @param ?string $label   The label to display
   * @param ?string $value   The value to display
   * @param ?string $icon    Optional icon to display
   *
   * @return void
   */
  public function __construct(
    public string $type = 'text',
    public string $classes = '',
    public string $align = 'left',
    public bool $isUrl = false,
    public ?string $label = null,
    public ?string $value = null,
    public ?string $icon = null,
  ) {

    if (!$icon) {
      switch ($type) {
        case 'amount':
          $this->icon = "currency_rupee";
          $this->align = "right";
          break;
        case 'timestamp':
          $this->icon = "schedule";
          break;
        case 'date':
          $this->icon = "today";
          break;
        default:
          $this->icon = 'short_text';
          break;
      }
    }
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vshow::components.info');
  }
}
