<?php

namespace V360\ShowComponents\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class DividerIcon extends Component
{
  /**
   * Create a new DividerIcon component instance.
   *
   * @param string $label The text to display in the divider
   * @param string $icon  The icon to display alongside the label
   * 
   * @return void
   */
  public function __construct(
    public string $label,
    public string $icon
  ) {
  }

  /**
   * Get the view / contents that represent the component.
   */
  public function render(): View|Closure|string
  {
    return view('vshow::components.divider-icon');
  }
}
