<?php

namespace V360\ShowComponents\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class ContainerLabel extends Component
{
  /**
   * Create a new ContainerLabel component instance.
   *
   * @param ?string $label  Optional label text for the container
   * @param ?string $icon   Optional icon name for the container
   * @param ?string $color  Background color class for the label (e.g., 'primary')
   * @param ?int $height Optional fixed height for the container in pixels
   * 
   * @return void
   */
  public function __construct(
    public ?string $label = null,
    public ?string $icon = null,
    public ?string $color = null,
    public ?int $height = null
  ) {
  }

  /**
   * Get the view / contents that represent the component.
   */
  public function render(): View|Closure|string
  {
    return view('vshow::components.container-label');
  }
}
