<?php

namespace V360\ShowComponents\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class ContainerIconList extends Component
{
  /**
   * Create a new ContainerIconList component instance.
   *
   * @param string $label The label for the container
   * @param array  $items Array of items where key is the label and value is the icon name
   *                     Format: ['label' => 'icon']
   * 
   * @return void
   */
  public function __construct(
    public string $label,
    public array $items
  ) {
  }

  /**
   * Get the view / contents that represent the component.
   */
  public function render(): View|Closure|string
  {
    return view('vshow::components.container-icon-list');
  }
}
