<?php

namespace V360\ShowComponents\View\Components;

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Str;
use Illuminate\View\Component;

class Breadcrumb extends Component
{

  /**
   * Create a new Breadcrumb component instance.
   *
   * @param array $links An array of breadcrumb links where key is the label and value is the URL (default: [])
   * 
   * @return void
   */
  public function __construct(
    public array $links = []
  ) {
    //
    if (count($links) == 0) {
      $routeName = Route::currentRouteName();
      if ($routeName !== 'home') {
        $tokens = Str::of($routeName)->explode('.');
        foreach ($tokens as $token) {
          $label = Str::of($token)->replace("_", " ");
          $label = Str::title($label);
          if ($label == 'Index') {
            $label = 'List';
          }
          $links[$label] = null;
        }
      }
    }
    $this->links = $links;
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vshow::components.breadcrumb');
  }
}
