# UI Components based on Bulma

A package providing reusable UI components based on Laravel and Bulma.

## Dependencies

- [Laravel Collective](https://laravelcollective.com/)
- [jQuery](https://jquery.com/)
- [Bulma CSS Framework](https://bulma.io/)

## Installation

```bash
$ composer require v360-tech/components-show
```

In case your Laravel version does NOT autoload the packages, add the service provider to config/app.php:

```php
V360\ShowComponents\ShowComponentsServiceProvider::class,
```

## Export

To publish views to your application:

```bash
php artisan vendor:publish --provider="V360\ShowComponents\ShowComponentsServiceProvider" --tag="vshow"
```

## Components

This package provides the following reusable UI components:

### Alert

Display alert messages with customizable styles.

```blade
<x-vshow-alert
    message="Operation successful"
    icon="check"  {{-- optional, default: 'info' --}}
    color="success"  {{-- optional, default: 'info' --}}
/>
```

### Breadcrumb

Display navigation breadcrumbs automatically generated from route names.

```blade
<x-vshow-breadcrumb
    :links="['Home' => '/', 'Users' => '/users']"  {{-- optional, auto-generates from route if empty --}}
/>
```

### Collection

Display a collection of items with optional keys and formatting.

```blade
<x-vshow-collection
    :items="$items"
    :keys="true"  {{-- optional, default: true --}}
    color="is-info"  {{-- optional, default: 'is-info' --}}
    label="Items"  {{-- optional --}}
    icon="list"  {{-- optional, default: 'short_text' if label set --}}
    align="left"  {{-- optional, default: 'left' --}}
/>
```

### ContainerEnum

Display enum values in a styled container.

```blade
<x-vshow-container-enum
    label="Status"
    :cases="['PENDING', 'APPROVED', 'REJECTED']"
    :useColor="false"  {{-- optional, default: false --}}
/>
```

### ContainerIconList

Display a list of items with icons in a container.

```blade
<x-vshow-container-icon-list
    label="Features"
    :items="['Feature 1' => 'check', 'Feature 2' => 'star']"
/>
```

### ContainerLabel

A labeled container for content with optional icon.

```blade
<x-vshow-container-label
    label="Section Title"  {{-- optional --}}
    icon="info"  {{-- optional --}}
    color="light"  {{-- optional, default: 'light' --}}
    :height="200"  {{-- optional, fixed height in pixels --}}
/>
```

### DividerIcon

A section divider with an icon.

```blade
<x-vshow-divider-icon
    label="Section"
    icon="arrow-right"
/>
```

### Features

Display a list of features with icons.

```blade
<x-vshow-features
    :items="$features"
    label="Features"  {{-- optional --}}
    icon="list"  {{-- optional, default: 'short_text' if label set --}}
    classes="has-text-black"  {{-- optional, default: 'has-text-black' --}}
    tagColor="is-success"  {{-- optional, default: 'is-success' --}}
    tagIcon="fa-check"  {{-- optional, default: 'fa-check' --}}
    tagSize="is-small"  {{-- optional, default: 'is-small' --}}
/>
```

### Icon Components

Various icon components for different use cases:

#### Icon

```blade
<x-vshow-icon
    :size="6"  {{-- optional, 4=large, 5=medium, 6=default, 7=small --}}
    title="Icon title"  {{-- optional --}}
    color="has-text-info"  {{-- optional --}}
/>
```

#### IconFa

Font Awesome icon wrapper.

```blade
<x-vshow-icon-fa />
```

#### IconHelp

Help icon with tooltip.

```blade
<x-vshow-icon-help
    title="Help text here"
/>
```

#### IconLabel

Icon with label text.

```blade
<x-vshow-icon-label
    icon="info"
/>
```

### Info Components

Various information display components:

#### Info

Display labeled information.

```blade
<x-vshow-info
    label="Label"  {{-- optional --}}
    value="Value"  {{-- optional --}}
    icon="info"  {{-- optional --}}
    type="text"  {{-- optional, default: 'text', options: 'text', 'amount', 'timestamp', 'date' --}}
    classes=""  {{-- optional --}}
    align="left"  {{-- optional, default: 'left' --}}
    :isUrl="false"  {{-- optional, default: false --}}
/>
```

#### InfoCount

Display a count with label.

```blade
<x-vshow-info-count
    info="Total"
    :count="42"
    color="info"  {{-- optional, default: 'info' --}}
    :width="128"  {{-- optional, default: 128 --}}
/>
```

#### InfoIcon

Display an icon with optional label.

```blade
<x-vshow-info-icon
    icon="info"  {{-- optional, default: 'info' --}}
    label="Information"  {{-- optional --}}
/>
```

#### InfoList

Display a list of labeled information.

```blade
<x-vshow-info-list
    :items="$items"
    labelClasses="is-italic has-text-info-dark has-text-right"  {{-- optional --}}
    contentClasses=""  {{-- optional --}}
/>
```

### Loading

Display a loading spinner with message.

```blade
<x-vshow-loading
    message="Loading..."  {{-- optional, default: 'Loading' --}}
    :isActive="false"  {{-- optional, default: false --}}
/>
```

### Modalshow

Display content in a modal dialog.

```blade
<x-vshow-modalshow
    title="Modal Title"  {{-- optional, default: '' --}}
    icon="fas fa-external-link-square-alt"  {{-- optional --}}
    tooltip="Click to open"  {{-- optional --}}
    size="medium"  {{-- optional, default: 'medium', options: 'small', 'medium', 'large' --}}
/>
```

### Status Components

#### Norecords

Display a "no records found" message.

```blade
<x-vshow-norecords
    type="primary"  {{-- optional, default: 'primary' --}}
    message="Records not found"  {{-- optional, default: 'Records not found' --}}
/>
```

#### Notfound

Display a "not found" message.

```blade
<x-vshow-notfound
    type="danger"  {{-- optional, default: 'danger' --}}
    message="Detail not found"  {{-- optional, default: 'Detail not found' --}}
/>
```

#### Status

Display a status indicator.

```blade
<x-vshow-status
    status="Active"
    :icon="true"  {{-- optional, default: true --}}
    class="is-info"  {{-- optional, default: 'is-info' --}}
    :label="false"  {{-- optional, default: false --}}
    size="normal"  {{-- optional --}}
/>
```

### Tag Components

#### TagDual

Display a two-part tag.

```blade
<x-vshow-tag-dual
    key="Label"
    value="Value"  {{-- optional --}}
    size="normal"  {{-- optional, default: 'normal' --}}
    :margin="true"  {{-- optional, default: true --}}
    color="info"  {{-- optional, default: 'info' --}}
/>
```

#### TagIcon

Display a tag with an icon.

```blade
<x-vshow-tag-icon
    icon="check"
    value="Verified"
    size="normal"  {{-- optional, default: 'normal' --}}
    class="info"  {{-- optional, default: 'info' --}}
    title="Tooltip text"  {{-- optional --}}
/>
```

### Timestamps

Display model timestamps.

```blade
<x-vshow-timestamps
    :record="$model"
/>
```

### Userstamps

Display model user stamps.

```blade
<x-vshow-userstamps
    :record="$model"
/>
```

### VideoStreamPlayer

Display a video player with advanced options.

```blade
<x-vshow-video-stream-player
    id="video-1"
    url="video.mp4"  {{-- optional --}}
    posterUrl="poster.jpg"  {{-- optional --}}
    :options="[  {{-- optional --}}
        'autoplay' => false,
        'controls' => true,
        'controlslist' => 'nodownload',
        'crossorigin' => 'anonymous',
        'disablepictureinpicture' => true,
        'disableremoteplayback' => true,
        'loop' => false,
        'muted' => false,
        'playsinline' => true,
        'preload' => 'metadata'
    ]"
/>
```

## Styling

### Loading Component Styles

Add the following SCSS code to your project's stylesheet:

```scss
.loader-wrapper {
  transition: opacity 0.3s;
  display: none;

  .loader {
    height: 40px;
    width: 40px;
  }

  &.is-active {
    display: flex;
    justify-content: center;
    align-items: center;
    flex-direction: column;
    border-radius: 6px;
  }
}
```

## License

MIT License. See [LICENSE](LICENSE) for more information.
