<?php

namespace V360\ShowComponents\View\Components;

use Illuminate\View\Component;

class VideoStreamPlayer extends Component
{

  /**
   * Create a new VideoStreamPlayer component instance.
   *
   * @param string      $id        The ID of the video element
   * @param ?string     $url       The URL of the video source (optional)
   * @param ?string     $posterUrl The URL of the video poster image (optional)
   * @param ?array      $options   Video player options array (optional)
   *                              Supported options:
   *                              - autoplay: bool (default: false)
   *                              - controls: bool (default: true)
   *                              - controlslist: string (default: 'nodownload')
   *                              - crossorigin: string (default: 'anonymous')
   *                              - disablepictureinpicture: bool (default: true)
   *                              - disableremoteplayback: bool (default: true)
   *                              - loop: bool (default: false)
   *                              - muted: bool (default: false)
   *                              - playsinline: bool (default: true)
   *                              - preload: string (default: 'metadata')
   * 
   * @return void
   */
  public function __construct(
    public string $id,
    public ?string $url = null,
    public ?string $posterUrl = null,
    public ?array $options = null,
    public string $attrs = ''
  ) {
    //
    $this->options = $options ?? [
      'autoplay' => false,
      'controls' => true,
      'controlslist' => 'nodownload', // 'nodownload', 'nofullscreen', 'noremoteplayback'
      'crossorigin' => 'anonymous', // 'anonymous', 'use-credentials'
      'disablepictureinpicture' => true,
      'disableremoteplayback' => true,
      'loop' => false,
      'muted' => false,
      'playsinline' => true,
      'preload' => 'metadata', // 'none', 'metadata', 'auto'
      'poster' => $this->posterUrl ?? '',
    ];
    // genereate attribute bag for the video tag using the options
    $this->attrs = collect($this->options)
      ->filter(fn($value) => $value !== false && $value !== '') // skip false and empty values
      ->map(fn($value, $key) => $value === true ? $key : $key . '=' . $value) // convert to key="value" or key
      ->join(' ');
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vshow::components.video-stream-player');
  }
}
