<?php

namespace V360\ShowComponents\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class TagIcon extends Component
{
  /**
   * Create a new TagIcon component instance.
   *
   * @param string  $icon   Icon name/class to display in the tag
   * @param string  $value  The text value to display in the tag
   * @param string  $size   Size of the tag ('small', 'normal', 'medium', 'large') (default: 'normal')
   * @param string  $class  CSS color class for the tag (default: 'info')
   * @param ?string $title  Optional tooltip text for the tag
   * 
   * @return void
   */
  public function __construct(
    public string $icon,
    public string $value,
    public string $size = 'normal',
    public string $class = 'info',
    public ?string $title = null
  ) {
  }

  /**
   * Get the view / contents that represent the component.
   */
  public function render(): View|Closure|string
  {
    return view('vshow::components.tag-icon');
  }
}
