<?php

namespace V360\ShowComponents\View\Components;

use Illuminate\View\Component;

class Notfound extends Component
{

  /**
   * Create a new Notfound component instance.
   *
   * @param string $type    The type/color of the not found message (default: 'danger')
   * @param string $message The message to display when item not found (default: 'Detail not found')
   * 
   * @return void
   */
  public function __construct(
    public string $type = 'danger',
    public string $message = 'Detail not found'
  ) {
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vshow::components.notfound');
  }
}
