<?php

namespace V360\ShowComponents\View\Components;

use Illuminate\View\Component;

class Norecords extends Component
{

  /**
   * Create a new Norecords component instance.
   *
   * @param string $type    The type/color of the no records message (default: 'primary')
   * @param string $message The message to display when no records found (default: 'Records not found')
   * 
   * @return void
   */
  public function __construct(
    public string $type = 'primary',
    public string $message = 'Records not found'
  ) {
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vshow::components.norecords');
  }
}
