<?php

namespace V360\ShowComponents\View\Components;

use Illuminate\Support\Str;
use Illuminate\View\Component;

class Modalshow extends Component
{
  /**
   * Create a new Modalshow component instance.
   *
   * @param string  $title   The modal title (default: "")
   * @param string  $icon    The icon class for the modal trigger (default: 'fas fa-external-link-square-alt')
   * @param ?string $tooltip Optional tooltip text for the modal trigger
   * @param string  $size    Modal size: 'small', 'medium', or 'large' (default: 'medium')
   *
   * @return void
   */
  public function __construct(
    public string $title = "",
    public string $icon = 'fas fa-external-link-square-alt',
    public string $size = 'is-modal-medium',
    public ?string $tooltip = null,
    public ?string $id = null
  ) {
    $this->id = $id ?? Str::uuid();
    // Set modal size class based on size parameter
    if ($size === 'small') {
      $this->size = '';
    } else if ($size === 'large') {
      $this->size = 'is-modal-large';
    }
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vshow::components.modalshow');
  }
}
