<?php

namespace V360\ShowComponents\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class InfoIcon extends Component
{
  /**
   * Create a new InfoIcon component instance.
   *
   * @param string  $icon  The icon to display (default: 'info')
   * @param ?string $label Optional label text to display with the icon
   * 
   * @return void
   */
  public function __construct(
    public string $icon = 'info',
    public ?string $label = null
  ) {
  }

  /**
   * Get the view / contents that represent the component.
   */
  public function render(): View|Closure|string
  {
    return view('vshow::components.info-icon');
  }
}
