<?php

namespace V360\ShowComponents\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class IconLabel extends Component
{

  /**
   * Create a new IconLabel component instance.
   *
   * @param string $icon The name/class of the icon to display
   * 
   * @return void
   */
  public function __construct(
    public string $icon
  ) {
  }

  /**
   * Get the view / contents that represent the component.
   */
  public function render(): View|Closure|string
  {
    return view('vshow::components.icon-label');
  }
}
