<?php

namespace V360\ShowComponents\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class IconHelp extends Component
{
  /**
   * Create a new IconHelp component instance.
   *
   * @param string $title The tooltip text to display when hovering over the help icon
   * 
   * @return void
   */
  public function __construct(
    public string $title
  ) {
  }

  /**
   * Get the view / contents that represent the component.
   */
  public function render(): View|Closure|string
  {
    return view('vshow::components.icon-help');
  }
}
