<?php

namespace V360\ShowComponents\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class Icon extends Component
{

  /**
   * Create a new Icon component instance.
   *
   * @param int     $size   Size of the icon (4=large, 5=medium, 6=default, 7=small) (default: 6)
   * @param ?string $title  Optional title/tooltip for the icon
   * @param ?string $color  Optional color class for the icon
   * 
   * @return void
   */
  public function __construct(
    public int $size = 6,
    public ?string $title = null,
    public ?string $color = null,
    public ?string $containerSize = null
  ) {
    $this->containerSize = match ($size) {
      7 => 'small',
      5 => 'medium',
      4 => 'large',
      default => null,
    };
  }

  /**
   * Get the view / contents that represent the component.
   */
  public function render(): View|Closure|string
  {
    return view('vshow::components.icon');
  }
}
