<?php

namespace V360\ShowComponents\View\Components;

use Illuminate\View\Component;

class Features extends Component
{
  /**
   * Create a new Features component instance.
   *
   * @param mixed    $items    The collection or array of feature items to display
   * @param mixed    $label    The label for the features section
   * @param ?string  $icon     Optional icon for the features section (default: 'short_text')
   * @param string   $classes  CSS classes for styling (default: 'has-text-black')
   * @param string   $tagColor Color class for feature tags (default: 'is-success')
   * @param string   $tagIcon  Icon class for feature tags (default: 'fa-check')
   * @param string   $tagSize  Size class for feature tags (default: 'is-small')
   * 
   * @return void
   */
  public function __construct(
    public mixed $items = null,
    public mixed $label = null,
    public string $classes = 'has-text-black',
    public string $tagColor = 'is-success',
    public string $tagIcon = 'fa-check',
    public string $tagSize = 'is-small',
    public ?string $icon = null,
    public int $size = 7
  ) {
    $this->icon = $icon ?? 'short_text';
    $this->size = $tagSize == 'is-large' || $tagSize == 'is-medium' ? 5 : 7;
  }

  /**
   * Get the view / contents that represent the component.
   *
   * @return \Illuminate\View\View|string
   */
  public function render()
  {
    return view('vshow::components.features');
  }
}
